% va vb vc variano da Vn a +-50%xVn step 15%xVn

clear all

%% INIZIALIZZAZIONE VARIABILI
Vn = 230;
factor = 0.7;
voltage = 0;

%% INIZIALIZZAZIONE DEL CANALE
fprintf('\n');
input('Premi INVIO per inizializzare il canale CAN...');
canch = canChannel('PEAK-System', 'PCAN_USBBUS1');
configBusSpeed(canch, 250000);
fprintf("Il canale è attivo\n")

%% ATTIVAZIONE DEL CANALE CAN
fprintf('\n');
input('Premi INVIO per comunicare con ITECH IT7900P...');
start(canch);
msg = canMessage(0x000,false,2);
msg.Data = [0x01 0x01];
transmit(canch, msg);

% lettura conferma attivazione canale
pause(1)
msg = receive(canch, Inf, 'OutputFormat','timetable');
if isempty(msg)
    fprintf("Errore di comunicazione con ITECH IT7900P\n")
else
    fprintf("ITECH IT7900P sta comunicando\n");
end

%% IMPOSTAZIONE MODALITA' TRIFASE
fprintf('\n');
input('Premi INVIO per impostare la modalità trifase...');
msg = canMessage(0x601, false, 8);
msg.Data = [0x23 0x01 0x30 0x02 0x01 0x00 0x00 0x00];
transmit(canch, msg)

% lettura conferma modalità trifase
msg = canMessage(0x601,false,8);
msg.Data = [0x43 0x01 0x30 0x02 0x00 0x00 0x00 0x00];
transmit(canch, msg);
pause(1)
msg = receive(canch, Inf, 'OutputFormat','timetable');
filtered = msg(msg.ID == 1409, :);
if isempty(filtered)
    fprintf('Nessun messaggio trovato con ID 581\n');
else
    lastMsg = filtered(end,:);
    data = lastMsg.Data{1};
    firstByte = data(1);
    fifthByte = data(5);
    if firstByte == 67 && fifthByte == 1 
        fprintf("Modalità trifase attivata\n")
    else
        fprintf("Problema attivazione modalità trifase\n")
    end                 
end

%% set balance mode: ON
fprintf('\n');
input('Premi INVIO per attivare il bilanciamento delle fasi...');
msg = canMessage(0x601, false, 8);
msg.Data = [0x23 0x03 0x30 0x01 0x01 0x00 0x00 0x00];
transmit(canch, msg);

% lettura conferma balance mode on
msg = canMessage(0x601,false,8);
msg.Data = [0x43 0x03 0x30 0x01 0x00 0x00 0x00 0x00];
transmit(canch, msg);
pause(1)
msg = receive(canch, Inf, 'OutputFormat','timetable');
filtered = msg(msg.ID == 1409, :);
if isempty(filtered)
    fprintf('Nessun messaggio trovato con ID 581\n');
else
    lastMsg = filtered(end,:);
    data = lastMsg.Data{1};
    firstByte = data(1);
    fifthByte = data(5);
    if firstByte == 67 && fifthByte == 1
        fprintf("Modalità bilanciamento delle fasi attivata correttamente\n");
    else
        fprintf("Problema attivazione bilanciamento delle fasi\n")
    end                 
end

%% INPUT SLEW RATE TENSIONE
fprintf('\n');
slewRate = input('Inserire un valore di slew rate per la tensione (0.0001 - 5000V/ms): ');
while  slewRate < 0.0001 || slewRate > 5000
    fprintf('\n');
    slewRate = input('Il valore inserito non rienta nei limiti, inserisci un nuovo valore(0.0001-5000V/ms): ');
end

msg = canMessage(0x601,false,8);
msg.Data = [0x23 0x03 0x30 0x05 (swapbytes(typecast(single(slewRate),'uint8')))];
transmit(canch, msg);

% lettura conferma impostazione slew rate 
msg = canMessage(0x601,false,8);
msg.Data = [0x43 0x03 0x30 0x05 0x00 0x00 0x00 0x00];
transmit(canch, msg);
pause(1)
msg = receive(canch, Inf, 'OutputFormat','timetable');
filtered =msg(msg.ID == 1409, :);
if isempty(filtered)
    fprintf('Nessun messaggio trovato con ID 581\n');
else
    lastMsg = filtered(end,:);
    data = lastMsg.Data{1};
    firstByte = data(1);
    if firstByte == 67
        value = data(end-3:end);
        realValue = typecast(swapbytes(value) , 'single');
        fprintf('Lo slew rate è stato impostato a: %.4f% V/ms\n', realValue);
    else
        fprintf("Problema impostazione dello slew rate\n")
    end                 
end

%% ATTIVAZIONE DELL'OUTPUT
fprintf('\n');
input('Premi INVIO per attivare l output...');
msg = canMessage(0x601, false, 8);
msg.Data = [0x23 0x02 0x30 0x01 0x01 0x00 0x00 0x00];
transmit(canch, msg);

% lettura conferma attivazione dell'uscita
msg = canMessage(0x601, false, 8);
msg.Data = [0x43 0x02 0x30 0x01 0x00 0x00 0x00 0x00];
transmit(canch, msg);
pause(1)
msg = receive(canch, Inf, 'OutputFormat','timetable');
filtered =msg(msg.ID == 1409, :);
if isempty(filtered)
    fprintf('Nessun messaggio trovato con ID 581\n');
else
    lastMsg = filtered(end,:);
    data = lastMsg.Data{1};
    firstByte = data(1);
    fifthByte = data(5);
    if firstByte == 67 && fifthByte == 1 
        fprintf("Output attivo\n");
    else
        fprintf("Problema attivazione dell'output\n");
    end                 
end

%% VOLTAGE DISTURBANCE TEST
fprintf('\n');
input('Premi INVIO per iniziare il voltage disturbance test...');

while factor <= 1.3

      voltage = Vn * factor;
     
      % IMPOSTAZIONE DELLA TENSIONE
      msg = canMessage(0x601,false,8);
      msg.Data = [0x23 0x03 0x30 0x02 (swapbytes(typecast(single(voltage),'uint8')))];
      transmit(canch, msg);
    
      % lettura conferma impostazione tensione 
      msg = canMessage(0x601,false,8);
      msg.Data = [0x43 0x03 0x30 0x02 0x00 0x00 0x00 0x00];
      transmit(canch, msg);
      pause(1)
      msg = receive(canch, Inf, 'OutputFormat','timetable');
      filtered = msg(msg.ID == 1409, :);
      if isempty(filtered)
         fprintf('Nessun messaggio trovato con ID 581\n');
      else
         lastMsg = filtered(end,:);
         data = lastMsg.Data{1};
         firstByte = data(1);
        if firstByte == 67
            value = data(end-3:end);
            realValue = typecast(swapbytes(value) , 'single');
            fprintf('Tensione: %.0f V\n', realValue)
        else
            fprintf("Problema impostazione della tensione\n")
        end                 
      end
pause(5)
factor = factor + 0.0652173913;
end

%% TERMINE PROVA
fprintf('\n');
input('Premi INVIO per terminare la prova...');

% DISATTIVAZIONE OUTPUT
msg = canMessage(0x601, false, 8);
msg.Data = [0x23 0x02 0x30 0x01 0x00 0x00 0x00 0x00];
transmit(canch, msg);
pause(1)
% lettura conferma disattivazione dell'uscita
msg = canMessage(0x601, false, 8);
msg.Data = [0x43 0x02 0x30 0x01 0x00 0x00 0x00 0x00];
transmit(canch, msg);
pause(1)
msg = receive(canch, Inf, 'OutputFormat','timetable');
filtered = msg(msg.ID == 1409, :);
if isempty(filtered)
    fprintf('Nessun messaggio trovato con ID 581\n');
else
    lastMsg = filtered(end,:);
    data = lastMsg.Data{1};
    firstByte = data(1);
    fifthByte = data(5);
    if firstByte == 67 && fifthByte == 0 
        fprintf("Output disattivato\n");
    else
        fprintf("Problema disattivazione dell'output\n");
    end                 
end

% IMPOSTAZIONE MODALITA' MONOFASE (imposta le tensioni a 0V in automatico)
msg = canMessage(0x601, false, 8);
msg.Data = [0x23 0x01 0x30 0x02 0x00 0x00 0x00 0x00];
transmit(canch, msg);

% lettura conferma modalità monofase
msg = canMessage(0x601,false,8);
msg.Data = [0x43 0x01 0x30 0x02 0x00 0x00 0x00 0x00];
transmit(canch, msg);
pause(2)
msg = receive(canch, Inf, 'OutputFormat','timetable');
filtered =msg(msg.ID == 1409, :);
if isempty(filtered)
    fprintf('Nessun messaggio trovato con ID 581\n');
else
    lastMsg = filtered(end,:);
    data = lastMsg.Data{1};
    firstByte = data(1);
    fifthByte = data(5);

    if firstByte == 67 && fifthByte == 0 
        fprintf("Modalità monofase attivata\n")
    else
        fprintf("Problema attivazione modalità monofase\n")
    end                 
end

% % IMPOSTAZIONE di va vb vc a 0
% msg_va = canMessage(0x601,false,8);
% msg_va.Data = [0x23 0x03 0x30 0x02 0x00 0x00 0x00 0x00];
% transmit(canch, msg_va);
% msg_vb = canMessage(0x601,false,8);
% msg_vb.Data = [0x23 0x03 0x30 0x03 0x00 0x00 0x00 0x00];
% transmit(canch, msg_vb);
% msg_vc = canMessage(0x601,false,8);
% msg_vc.Data = [0x23 0x03 0x30 0x04 0x00 0x00 0x00 0x00];
% transmit(canch, msg_vc);
% DISATTIVAZIONE COMUNICAZIONE ITECH IT7900P

% DISATTIVAZIONE COMUNICAZIONE ITECH IT7900P
stop(canch);
% lettura conferma disattivazione canale
pause(1)
msg = receive(canch, Inf, 'OutputFormat','timetable');
if isempty(msg)
    fprintf("Il canale CAN è spento\n");
else
    fprintf("Errore di comunicazione con ITECH IT7900P\n")
end
